function [launchVehicle_best,LVModelFileName_best,satPerVehicle_best,numberOfLaunch_best,launchSite_best,...
        LPModelFileName_best,LSla_best,LSlo_best,LSR_best,minLaunchCost,LScounter,costPerLaunchl_best,...
        costPerLaunchh_best,burnoutVelocity_best] = launch(Msat,incli,alti,Nmin,PIIoption)
% launch.m
% Darren Chang (darrenz@mit.edu)
% Last modified by 2/27/03

% This program takes mass and volume of satellite, satellite altitude,
% and minimum elevation angle as inputs, and returns a suggestion
% to the user on the types of launch vehicles to use, the launch
% sites, the cost, the availability, and other factors which will
% be decided later.
%
% The source of data in this program is from International 
% Reference Guide to Space Launch Systems, 1999.  Published
% by AIAA.
%
% Except:
% LM2C; source: www.calt.com.cn
% Ariane 5; source: www.arianespace.com

% Msat	- satellite mass in kg
% Vsat   - satellite volume in m^3
% Mpl		- payload mass in kg
% Mfairing_tmp - fairing mass in kg
% Vfairing_tmp - fairing volume in m^3
% alti	- satellite altitude in km
% incli_dg	- inlination angle in degree
% Mli		- payload mass at low inclination angle
% Mhi		- payload mass at high inclination angle
% inclil	- low inclinaiton angle
% inclih	- high inclination angle
% modifyM		- flag array.		modifyM = 1 -> it's worth to modifyM the satellite to have one more fit in the fairing
%										modifyM = 0 -> it's not worth to modifyM the satellite to have one more fit in the fairing
% launchSite	- cell array that contains the names of the capable LVs
% LSla			- array that contains the latitudes of capable LVs
% LSlo			- array that contains the logitudes of capable LVs

% problems yet to be solved:
% 1. add other launchers including Ariane and Proton


if PIIoption(1) == 1
    noForeignLV = 1;
else
    noForeignLV = 0;
end;

Vsat = Msat/234.18;

dtr = pi/180;
rtd = 180/pi;
incli_dg		= incli*rtd;		% inclination angle in radian
LScounter	= 0;					% launch site counter that counts for capable launch sites

% LV 1: Atlas IIIA
% Page 59
% Launch from:	Cape Canaveral, inclination 28.5 - 63 deg (55 - 63 deg is achieved by plane change)
%					Vandenberg AFB, inclination 63 - 120 deg

Vfairing_tmp		= 43.9;				% large payload fairing (LPF)
Mfairing_tmp		= 2085;				% LPF
LSR_tmp			= 0.869;					% launch success ratio

if incli_dg >= 28.5 & incli_dg <= 120
   if alti >= 185 & alti <= 1850
      if incli_dg < 45
         inclil = 28.5;
         inclih = 45;
         Mli = -1.05*alti + 8694.3;
      	Mhi = -1.02*alti + 8388.9;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;	% interplate to find the allowed payload
      elseif incli_dg >= 45 & incli_dg < 55
         inclil = 45;
         inclih = 55;
         Mli = -1.02*alti + 8388.9;
      	Mhi = -.964*alti + 8053.3;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      elseif incli_dg >= 55 & incli_dg < 63.4
         inclil = 55;
         inclih = 63.4;
         Mli = -.964*alti + 8053.3;
      	Mhi = -.938*alti + 7736.1;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      elseif incli_dg >= 63.4 & incli_dg < 90
         inclil = 63.4;
         inclih = 90;
         Mli = -.938*alti + 7736.1;
      	Mhi = -.851*alti + 7074.1;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      elseif incli_dg >= 90
         inclil = 90;
         inclih = 98.2;
         Mli = -.851*alti + 7074.1;
      	Mhi = -.921*alti + 6903.7;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;         
      end;
      if (floor(Mpl/Msat) > 0) & (floor(Vfairing_tmp/Vsat) > 0)
         LScounter = LScounter + 1;
         launchVehicle{LScounter} 	= cellstr('Atlas_IIIA');			% LV name
         LVModelFileName{LScounter}	= cellstr('atlas3a.mdl');			% model file name in STK
         burnoutVelocity(LScounter)	= 8000;									% burnout velocity, set to 300km/s for now
         satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));					% satellite per LV
         numberOfLaunch(LScounter) 	= ceil(Nmin/satPerVehicle(LScounter));		% number of launches required
         costPerLaunchl(LScounter) 	= 90000;									% lower bound of cost per launch
         costPerLaunchh(LScounter) 	= 105000;								% upper bound of cost per launch
         totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);	% lower bound of total cost
         totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);	% upper bound of total cost
         % string expression of total cost
         totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
         if incli_dg >= 28.5 & incli_dg <= 63
            launchSite{LScounter} = cellstr('Cape_Canaveral');
            LPModelFileName{LScounter} = cellstr('delta4-lp.mdl');	% launch pad model file
            LSla(LScounter) = 28.5*dtr;	% launch site latitude in radian
            LSlo(LScounter) = -81.0*dtr;	% launch site longitude in radian
         else
            launchSite{LScounter} = cellstr('Vandenberg_AFB');
            LPModelFileName{LScounter} = cellstr('atlas-lp.mdl');
            LSla(LScounter) = 34.4*dtr;	% launch site latitude in radian
            LSlo(LScounter) = -120.35*dtr;% launch site longitude in radian
         end;
         if (Mpl/Msat - floor(Mpl/Msat)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyM(LScounter) = 1;
         else
            modifyM(LScounter) = 0;
         end;
         if (Vfairing_tmp/Mpl - floor(Vfairing_tmp/Mpl)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyV(LScounter) = 1;
         else
            modifyV(LScounter) = 0;
         end;
         Vfairing(LScounter) = Vfairing_tmp;
         Mfairing(LScounter) = Mfairing_tmp;
         LSR(LScounter)		  = LSR_tmp;
      else		% satellite too heavy
      end
   else			% not within altitude range
   end;
end;



% LV 2: Delta II 7920
% Page 96
% Launch from:	Cape Canaveral, inclination 28.5 - 60 deg
%					Vandenberg AFB, inclination 63 - 145 deg
% 9.5-ft diameter fairing accounted

Vfairing_tmp		= 16.0;				% 9.5-ft diameter fairing
Mfairing_tmp		= 841;				% LPF
LSR_tmp			= 0.975;				% no launch history for Atlas IIIA.  Estimation based on all Atlas family

if (incli_dg >= 28.5 & incli_dg <= 60 ) | (incli_dg >= 63 & incli_dg <= 145)
   if alti >= 185 & alti <= 2000
      inclil = 28.7;
      inclih = 90;
      Mli = -0.942*alti + 5184.3;
      Mhi = -0.826*alti + 4102.9;
      Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli;	% interplate to find the allowed payload
      if (floor(Mpl/Msat) > 0) & (floor(Vfairing_tmp/Vsat) > 0)
         LScounter = LScounter + 1;
         launchVehicle{LScounter} 	= cellstr('Delta_II_7920');
         LVModelFileName{LScounter}	= cellstr('del7920.mdl');		% model file name in STK
         burnoutVelocity(LScounter)	= 8000;								% burnout velocity, set to 300km/s for now
         satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));
         numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));
         costPerLaunchl(LScounter) 	= 50000;
         costPerLaunchh(LScounter) 	= 60000;
         totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);
         totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);
         totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
         if incli_dg >= 28.5 & incli_dg <= 60
            launchSite{LScounter} = cellstr('Cape_Canaveral');
            LPModelFileName{LScounter} = cellstr('delta4-lp.mdl');
            LSla(LScounter) = 28.5*dtr + 0.005;		% launch site latitude in radian
            LSlo(LScounter) = -81.0*dtr + 0.005;		% launch site longitude in radian
         else
            launchSite{LScounter} = cellstr('Vandenberg_AFB');
            LPModelFileName{LScounter} = cellstr('atlas-lp.mdl');
            LSla(LScounter) = 34.4*dtr + 0.005;		% launch site latitude in radian
            LSlo(LScounter) = -120.35*dtr + 0.005;	% launch site longitude in radian
         end;
         if (Mpl/Msat - floor(Mpl/Msat)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyM(LScounter) = 1;
         else
            modifyM(LScounter) = 0;
         end;
         if (Vfairing_tmp/Mpl - floor(Vfairing_tmp/Mpl)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyV(LScounter) = 1;
         else
            modifyV(LScounter) = 0;
         end;
         Vfairing(LScounter) = Vfairing_tmp;
         Mfairing(LScounter) = Mfairing_tmp;
         LSR(LScounter)		  = LSR_tmp;
      else		% satellite too heavy
      end
   else			% not within altitude range
   end;
end;



% LV5: Pegasus XL
% Page 269
% Launch from:	Vandenberg AFB, inclination 70 - 130 deg
%					Wallops Flight Facility, inclination 38 - 55 deg
%					Cape Canaveral Air Station, inclination 28 - 51 deg
%					Kwajalein Missile Range, Marshall Islands, equatorial
%					Potentially anywhere, inclination 0 - 180 deg

Vfairing_tmp		= 1.89;				% 
Mfairing_tmp		= 170;				% 
LSR_tmp			= 0.833;				% 

if incli_dg >= 0 & incli_dg <= 180
   if alti >= 185 & alti <= 1850
      if incli_dg < 29
         inclil = 0;
	      inclih = 29;
         Mli = -0.269*alti + 538.8;
      	Mhi = -0.248*alti + 499.7;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;	% interplate to find the allowed payload
      elseif incli_dg >= 29 & incli_dg < 45
         inclil = 29;
	      inclih = 45;
         Mli = -0.248*alti + 499.7;
      	Mhi = -0.217*alti + 476.3;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      elseif incli_dg >= 45 & incli_dg < 65
         inclil = 45;
	      inclih = 65;
         Mli = -0.217*alti + 476.3;
      	Mhi = -0.193*alti + 428.5;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      elseif incli_dg >= 65 & incli_dg < 90
         inclil = 65;
	      inclih = 90;
         Mli = -0.193*alti + 428.5;
      	Mhi = -0.173*alti + 374.4;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      elseif incli_dg >= 90
         inclil = 90;
	      inclih = 98.2;
         Mli = -0.173*alti + 374.4;
      	Mhi = -0.167*alti + 356.5;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      end;
      if (floor(Mpl/Msat) > 0) & (floor(Vfairing_tmp/Vsat) > 0)
         if incli_dg >= 28 & incli_dg <= 51
            LScounter = LScounter + 1;
            launchVehicle{LScounter} 	= cellstr('Pegasus_XL1');
         	LVModelFileName{LScounter}	= cellstr('pegasus.mdl');		% model file name in STK
         	burnoutVelocity(LScounter)	= 8000;								% burnout velocity, set to 300km/s for now
         	satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));
            numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));
         	costPerLaunchl(LScounter) 	= 12000;
         	costPerLaunchh(LScounter) 	= 15000;
         	totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);
         	totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);
         	totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
            launchSite{LScounter} = cellstr('Cape_Canaveral');
            LPModelFileName{LScounter} = cellstr('delta4-lp.mdl');
            LSla(LScounter) = 28.5*dtr + 0.005;	% launch site latitude in radian
            LSlo(LScounter) = -81.0*dtr - 0.005;	% launch site longitude in radian
         end;
         if incli_dg >= 70 & incli_dg <= 130
            LScounter = LScounter + 1;
            launchVehicle{LScounter} 	= cellstr('Pegasus_XL2');
            LVModelFileName{LScounter}	= cellstr('pegasus.mdl');		% model file name in STK
	         burnoutVelocity(LScounter)	= 8000;								% burnout velocity, set to 300km/s for now
            satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));
            numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));
         	costPerLaunchl(LScounter) 	= 12000;
         	costPerLaunchh(LScounter) 	= 15000;
         	totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);
         	totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);
         	totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
            launchSite{LScounter} = cellstr('Vandenberg_AFB');
            LPModelFileName{LScounter} = cellstr('atlas-lp.mdl');
            LSla(LScounter) = 34.4*dtr + 0.005;	% launch site latitude in radian
            LSlo(LScounter) = -120.35*dtr - 0.005;% launch site longitude in radian
         end;
         if incli_dg >= 38 & incli_dg <= 55
            LScounter = LScounter + 1;
            launchVehicle{LScounter} 	= cellstr('Pegasus_XL3');
            LVModelFileName{LScounter}	= cellstr('pegasus.mdl');		% model file name in STK
	         burnoutVelocity(LScounter)	= 8000;								% burnout velocity, set to 300km/s for now
            satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));
            numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));
         	costPerLaunchl(LScounter) 	= 12000;
         	costPerLaunchh(LScounter) 	= 15000;
         	totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);
         	totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);
         	totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
            launchSite{LScounter} = cellstr('Wallops_Flight_Facility');
            LPModelFileName{LScounter} = cellstr('pad.mdl');
            LSla(LScounter) = 37.8*dtr;			% launch site latitude in radian
            LSlo(LScounter) = -75.5*dtr;			% launch site longitude in radian
         end;
         if incli_dg >= 0 & incli_dg <= 15
            LScounter = LScounter + 1;
            launchVehicle{LScounter}	= cellstr('Pegasus_XL4');
            LVModelFileName{LScounter}	= cellstr('pegasus.mdl');		% model file name in STK
	         burnoutVelocity(LScounter)	= 8000;								% burnout velocity, set to 300km/s for now
            satPerVehicle(LScounter)	= floor(Mpl/Msat);
            numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));
         	costPerLaunchl(LScounter) 	= 12000;
         	costPerLaunchh(LScounter) 	= 15000;
         	totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);
         	totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);
         	totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
            launchSite{LScounter} = cellstr('Kwajalein_Missile_Range');
            LPModelFileName{LScounter} = cellstr('pad.mdl');
            LSla(LScounter) = 9.3986*dtr;			% launch site latitude in radian
            LSlo(LScounter) = 167.4289*dtr;		% launch site longitude in radian
         end;
         if (Mpl/Msat - floor(Mpl/Msat)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyM(LScounter) = 1;
         else
            modifyM(LScounter) = 0;
         end;
         if (Vfairing_tmp/Mpl - floor(Vfairing_tmp/Mpl)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyV(LScounter) = 1;
         else
            modifyV(LScounter) = 0;
         end;
         Vfairing(LScounter) = Vfairing_tmp;
         Mfairing(LScounter) = Mfairing_tmp;
         LSR(LScounter)		  = LSR_tmp;
      else		% satellite too heavy
      end
   else			% not within altitude range
   end;
end;



if noForeignLV == 1
    ;
else
% LV3: H-IIA202
% Page 144
% Launch from:	Tanegashima Space Center, inclination 28.5 - 100 deg
% 100 kg Payload Adapter accounted for

Vfairing_tmp		= 90.0;				% Model 5S
Mfairing_tmp		= 1716;				% LPF
LSR_tmp			= 0.833;				% no launch history for H-IIA.  Estimation based on H-II

if (incli_dg >= 28.5 & incli_dg <= 100 )
   if alti >= 300 & alti <= 2000
      if alti >= 300 & alti < 1000
         if incli_dg < 51.6
            inclil = 30.4;
            inclih = 51.6;
            Mli = -6.43*alti + 11928.6;
            Mhi = -5.83*alti + 10833.3;
            Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
         elseif incli_dg >= 51.6
            inclil = 51.6;
            inclih = 98.2;
            Mli = -5.83*alti + 10833.3;
            Mhi = -3.80*alti + 7282.4;
            Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
         end;
	   elseif alti >= 1000 & alti <= 2000
   	   inclil = 30.4;
      	inclih = 51.6;
	      Mli = -0.583*alti + 7666.6;
   	   Mhi = -0.667*alti + 7333.4;
      	Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
	   end;
   	if (floor(Mpl/Msat) > 0) & (floor(Vfairing_tmp/Vsat) > 0)
      	LScounter = LScounter + 1;
      	launchVehicle{LScounter} 	= cellstr('H-IIA202');
         LVModelFileName{LScounter}	= cellstr('h2a.mdl');			% model file name in STK
         burnoutVelocity(LScounter)	= 8000;								% burnout velocity, set to 300km/s for now
      	satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));
	      numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));
         costPerLaunchl(LScounter) 	= 75000;
         costPerLaunchh(LScounter) 	= 95000;
         totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);
         totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);
         totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
   	   if incli_dg >= 28.5 & incli_dg <= 100
            launchSite{LScounter} = cellstr('Tanegashima_Space_Center');
            LPModelFileName{LScounter} = cellstr('pad.mdl');
         	LSla(LScounter) = 30.4*dtr;			% launch site latitude in radian
	         LSlo(LScounter) = 130.966*dtr;		% launch site longitude in radian
   	   else
      	end;
	      if (Mpl/Msat - floor(Mpl/Msat)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
   	      modifyM(LScounter) = 1;    
      	else
         	modifyM(LScounter) = 0;
         end;
         if (Vfairing_tmp/Mpl - floor(Vfairing_tmp/Mpl)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyV(LScounter) = 1;
         else
            modifyV(LScounter) = 0;
         end;
         Vfairing(LScounter) = Vfairing_tmp;
         Mfairing(LScounter) = Mfairing_tmp;
         LSR(LScounter)		  = LSR_tmp;
   	else	% satellite too heavy
	   end;
	else		% not within altitude range
   end;
else			% not within inclination range
end;


% LV4: Long March 2C
% Launch from:	Taiyuan Satellite Launch Center, inclination 69 - 98 deg
%					Jiuquan Satellite Launch Center, inclination 56.9 - 69 deg

Vfairing_tmp		= 28.7;			% LM-2C fairing
Mfairing_tmp		= 0;				% no data available. Estimated from the Iridium case.  
% LM2C launch capability after subtracting fairing should
% be greater than 1360kg (2 Iridiums).
LSR_tmp			= 1.00;				% 

if incli_dg >= 28.5 & incli_dg <= 98.2
   if alti >= 300 & alti <= 1500
      if incli_dg < 63
         inclil = 50;
	      inclih = 63;
         Mli = -0.96*alti + 3289.0;
      	Mhi = -0.92*alti + 3041.0;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;	% interplate to find the allowed payload
      elseif incli_dg >= 63 & incli_dg < 86
         inclil = 63;
	      inclih = 86;
         Mli = -0.92*alti + 3041.0;
      	Mhi = -0.83*alti + 2536;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      elseif incli_dg >= 86
         inclil = 86;
	      inclih = 98.2;
         Mli = -0.83*alti + 2536;
      	Mhi = -0.785*alti + 2256.5;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      end;
      if (floor(Mpl/Msat) > 0) & (floor(Vfairing_tmp/Vsat) > 0)
         LScounter = LScounter + 1;
         launchVehicle{LScounter} 	= cellstr('Long_March_2C');
         LVModelFileName{LScounter}	= cellstr('rocket.mdl');			% model file name in STK
         burnoutVelocity(LScounter)	= 8000;								% burnout velocity, set to 300km/s for now
         satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));
         numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));
         costPerLaunchl(LScounter) 	= 20000;
         costPerLaunchh(LScounter) 	= 25000;
         totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);
         totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);
         totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
         if incli_dg >= 28.5 & incli_dg <= 69
            launchSite{LScounter} = cellstr('Jiuquan_Satellite_Launch_Center');
            LPModelFileName{LScounter} = cellstr('pad.mdl');
            LSla(LScounter) = 40.6*dtr;			% launch site latitude in radian
            LSlo(LScounter) = 99.9*dtr;			% launch site longitude in radian
         else
            launchSite{LScounter} = cellstr('Taiyuan_Satellite_Launch_Center');
            LPModelFileName{LScounter} = cellstr('pad.mdl');
            LSla(LScounter) = 37.5*dtr;			% launch site latitude in radian
            LSlo(LScounter) = 112.6*dtr;			% launch site longitude in radian
         end;
         if (Mpl/Msat - floor(Mpl/Msat)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyM(LScounter) = 1;
         else
            modifyM(LScounter) = 0;
         end;
         if (Vfairing_tmp/Mpl - floor(Vfairing_tmp/Mpl)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyV(LScounter) = 1;
         else
            modifyV(LScounter) = 0;
         end;
         Vfairing(LScounter) = Vfairing_tmp;
         Mfairing(LScounter) = Mfairing_tmp;
         LSR(LScounter)		  = LSR_tmp;
      else		% satellite too heavy
      end
   else			% not within altitude range
   end;
end;



% LV 6: Ariane 5
% www.arianespace.com
% Launch from:	Guiana Space Center

Vfairing_tmp		= 169.8;				% large payload fairing (LPF)
Mfairing_tmp		= 2900;				% Long Fairing
LSR_tmp			    = 0.333;			% launch success ratio

if incli_dg >= 5.2 & incli_dg <= 100.5
   if alti >= 300 & alti <= 1400
      if incli_dg < 60
         inclil = 48;
         inclih = 60;
         Mli = -3.27*alti + 21582;
      	 Mhi = -3.55*alti + 21264;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;	% interplate to find the allowed payload
      elseif incli_dg >= 60
         inclil = 60;
         inclih = 86;
         Mli = -3.55*alti + 21264;
      	 Mhi = -2.82*alti + 18045;
         Mpl = (incli_dg - inclil)/(inclih - inclil)*(Mhi - Mli) + Mli - Mfairing_tmp;
      end;
      if (floor(Mpl/Msat) > 0) & (floor(Vfairing_tmp/Vsat) > 0)
         LScounter = LScounter + 1;
         launchVehicle{LScounter} 	= cellstr('Ariane5');	    		% LV name
         LVModelFileName{LScounter}	= cellstr('ariane5.mdl');			% model file name in STK
         burnoutVelocity(LScounter)	= 8000;									% burnout velocity, set to 300km/s for now
         satPerVehicle(LScounter) 	= min(floor(Mpl/Msat),floor(Vfairing_tmp/Vsat));					% satellite per LV
         numberOfLaunch(LScounter) 	= ceil(Nmin/floor(Mpl/Msat));		% number of launches required
         costPerLaunchl(LScounter) 	= 150000;							% lower bound of cost per launch
         costPerLaunchh(LScounter) 	= 180000;							% upper bound of cost per launch
         totalCostl(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchl(LScounter);	% lower bound of total cost
         totalCosth(LScounter)		= numberOfLaunch(LScounter)*costPerLaunchh(LScounter);	% upper bound of total cost
         % string expression of total cost
         totalCost{LScounter}			= strcat(num2str(totalCostl(LScounter)),' - ',num2str(totalCosth(LScounter)),' million dollars');
         launchSite{LScounter} = cellstr('Guiana_Space_Center');
         LPModelFileName{LScounter} = cellstr('ariane-lp.mdl');
         LSla(LScounter) = 5.2*dtr;	% launch site latitude in radian
         LSlo(LScounter) = -52.8*dtr;% launch site longitude in radian
         if (Mpl/Msat - floor(Mpl/Msat)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyM(LScounter) = 1;
         else
            modifyM(LScounter) = 0;
         end;
         if (Vfairing_tmp/Mpl - floor(Vfairing_tmp/Mpl)) > 0.5	% worth of modifyMing the satellite to fit more sates. on a LV
            modifyV(LScounter) = 1;
         else
            modifyV(LScounter) = 0;
         end;
         Vfairing(LScounter) = Vfairing_tmp;
         Mfairing(LScounter) = Mfairing_tmp;
         LSR(LScounter)		  = LSR_tmp;
      else		% satellite too heavy
      end
   else			% not within altitude range
   end;
end;

end; % if noForeignLV == 1



if LScounter == 0                   % no LV is capable of the launch
    minLaunchCost = 0;
    launchVehicle_best = cellstr('NotAvailable');
    LVModelFileName_best = cellstr('NotAvailable');
    satPerVehicle_best = 0;
    numberOfLaunch_best = 0;
    launchSite_best = '';
    LPModelFileName_best = '';
    LSla_best = 0;
    LSlo_best = 0;
    LSR_best = 0;
    costPerLaunchl_best = 0;
    costPerLaunchh_best = 0;
    burnoutVelocity_best = 0;
elseif LScounter > 0
    totalCost = (totalCostl + totalCosth)/2;    % in K$
    [minLaunchCost,i] = min(totalCost);
    launchVehicle_best = launchVehicle{i};
    LVModelFileName_best = LVModelFileName{i};
    satPerVehicle_best = satPerVehicle(i);
    numberOfLaunch_best = numberOfLaunch(i);
    launchSite_best = launchSite{i};
    LPModelFileName_best = LPModelFileName{i};
    LSla_best = LSla(i);
    LSlo_best = LSlo(i);
    LSR_best = LSR(i);
    costPerLaunchl_best = costPerLaunchl(i);
    costPerLaunchh_best = costPerLaunchh(i);
    burnoutVelocity_best = burnoutVelocity(i);
end;